import scrapy

from spider_douban.items import SpiderDoubanItem


class DoubanMovieSpider(scrapy.Spider):
    name = 'douban_movie'
    allowed_domains = ['https://movie.douban.com/top250']
    start_urls = ['https://movie.douban.com/top250/']

    def parse(self, response):
        for each in response.xpath('//*[@id="content"]/div/div[1]/ol/li'):
            item = SpiderDoubanItem()
            item['title'] = each.xpath('div/div[2]/div[1]/a/span[1]/text()').extract_first()
            item['rank'] = each.xpath('div/div[2]/div[2]/div/span[2]/text()').extract_first()
            item['subject'] = each.xpath('div/div[2]/div[2]/p[2]/span/text()').extract_first()
            yield item
